"""
Plots Lmax/Lupper with all different architectures
"""

P_4q = [12, 24, 48, 72, 96, 120]
arch1_4q = [0.0986, 0.0568, 0.0494, 0.0447, 0.0381, 0.0310]
arch2_4q = [0.0208, 0.0283, 0.0320, 0.0327, 0.0373, 0.0339]
arch3_4q = [0.0416, 0.0287, 0.0358, 0.0356, 0.0400, 0.0423]

# 2 QUBIT, 1,5,10,15,20 LAYERS, 3 GATES, 100 S
P_2q = [6, 30, 60, 90, 120]
arch1_2q = [0.3197, 0.1603, 0.1570, 0.1320, 0.1390]
arch2_2q = [0.0833, 0.1450, 0.1358, 0.1467, 0.1418]
arch3_2q = [0.1663, 0.1443, 0.1671, 0.1667, 0.1858]

import matplotlib.pyplot as plt
import seaborn as sns
import numpy as np
from matplotlib.lines import Line2D


# 4-Qubit Data
P_4q = [12, 24, 48, 72, 96, 120]
arch1_4q = np.array([0.0986, 0.0568, 0.0494, 0.0447, 0.0381, 0.0410]) * 100
arch2_4q = np.array([0.0208, 0.0283, 0.0320, 0.0327, 0.0373, 0.0339]) * 100
arch3_4q = np.array([0.0416, 0.0287, 0.0358, 0.0356, 0.0400, 0.0423]) * 100

# 2-Qubit Data
P_2q = [6, 30, 60, 90, 120]
arch1_2q = np.array([0.3197, 0.1603, 0.1570, 0.1320, 0.1390]) * 100
arch2_2q = np.array([0.0833, 0.1450, 0.1358, 0.1467, 0.1418]) * 100
arch3_2q = np.array([0.1663, 0.1443, 0.1671, 0.1667, 0.1758]) * 100


sns.set_theme(style="whitegrid")
fig,ax = plt.subplots(figsize=(10, 6))
ax.set_facecolor('gainsboro')
colors = sns.color_palette("colorblind", 3)

plt.plot(P_4q, arch1_4q, marker='o', linestyle='-', linewidth=4, markersize=8, color=colors[0])
plt.plot(P_4q, arch2_4q, marker='s', linestyle='-', linewidth=4, markersize=8, color=colors[1])
plt.plot(P_4q, arch3_4q, marker='^', linestyle='-', linewidth=4, markersize=10, color=colors[2])

plt.plot(P_2q, arch1_2q, marker='o', linestyle='--', linewidth=4, markersize=8, color=colors[0])
plt.plot(P_2q, arch2_2q, marker='s', linestyle='--', linewidth=4, markersize=8, color=colors[1])
plt.plot(P_2q, arch3_2q, marker='^', linestyle='--', linewidth=4, markersize=10, color=colors[2])

plt.xlabel('Number of Parameters (P)', fontsize=20)
plt.ylabel(r'$\tilde{L}_{max} / L_{upper}$ (%)', fontsize=20)

legend_elements = [
    Line2D([0], [0], marker='o', color='w', label='Standard Ring',
           markerfacecolor=colors[0], markersize=10),
    Line2D([0], [0], marker='s', color='w', label='Linear CZ',
           markerfacecolor=colors[1], markersize=8),
    Line2D([0], [0], marker='^', color='w', label='All-to-All CNOT',
           markerfacecolor=colors[2], markersize=10),
    Line2D([0], [0], color='black', lw=2, linestyle='-', label='n = 4'),
    Line2D([0], [0], color='black', lw=2, linestyle='--', label='n = 2')
]

plt.legend(handles=legend_elements, title='Ansatz Architecture (Qubits)', fontsize=16, ncol=2, framealpha=1.0, title_fontsize=16)

ax.tick_params(labelsize=20)
plt.grid(True, which='both', linestyle='--')
plt.tight_layout()
plt.show()